#version 460

uniform mat4 m_pvm;
uniform mat4 m_m;
uniform vec3 cam_pos;

in vec4 position;
in vec4 normal;

out vec3 n;
out vec3 incident;

void main() {

    mat4 m = inverse(transpose(m_m));
    n = normalize(vec3(m * normal));   // world space

    incident = vec3(m_m * position) - cam_pos;  // world space

    gl_Position = m_pvm * position;
}

